function hyper = vec_to_bmksq(vec,ninp,nprior,nhid,nout,nSa,nB);

if nargin < 3,
  nprior = 1;
end

vec = real(vec);
ntot = length(vec);

B = reshape(vec(1:nhid*ninp*nB),nhid,ninp,nB);
M = reshape(vec(nhid*ninp+1:nhid*ninp+(nhid+1)*nprior),nhid+1,nprior);
D = vec(nhid*ninp+(nhid+1)*nprior+1:nhid*ninp+(nhid+1)*nprior+nhid);
K = zeros(nhid+1);
upperdiag = find(triu(ones(nhid+1)));
for i = 1:nSa
  sam = nhid*ninp+(nhid+1)*nprior+nhid + (i-1)*(nhid+1)*(nhid+2)/2;
  K(upperdiag) = vec(sam+1:sam+(nhid+1)*(nhid+2)/2);
  K1(:,:,i) = K+K'-diag(diag(K));
end;
sam = sam + (nhid+1)*(nhid+2)/2 + 1;
S = vec(sam);
q = reshape(vec(sam+1:end),nprior,length(vec(sam+1:end))/nprior);

hyper.B = B;
hyper.M = M(:,1:nprior);
hyper.D = D;
hyper.K = K1;
hyper.S = S(1);
hyper.q = q;
