function ind = make_ind(nhid,ninp,nprior,nSa,nB,nfeature)

if (nargin < 6)
  nfeature = 1;
end;

lM = nhid + 1;

ll = nhid*ninp*nB + lM*nprior + nB*nhid + nSa*lM*(lM+1)/2 + 1 + nprior*nfeature;
%         B            M          D1             K          S         Q

if nprior == 1
  ind = [1:ll]';
else
  for i = 1:nprior
    if (nB > 1)
      ding = [(i-1)*nhid*ninp+1:i*nhid*ninp];
	  sam = nprior*nhid*ninp;
    else
      ding = [1:nhid*ninp];
	  sam = nhid*ninp;
    end;
    ding = [ding,sam + [(i-1)*lM + 1 : i*lM]];
    sam = sam + nprior*lM;
	if (nB > 1)
      ding = [ding,sam + [(i-1)*nhid + 1 : i*nhid]];
	  sam = sam + nprior*nhid;
	else
	  ding = [ding,sam + [1 : nhid]];
      sam = sam + nhid;
	end;
    if (nSa > 1)
	  ding = [ding,sam + [(i-1)*lM*(lM+1)/2 + 1 : i*lM*(lM+1)/2]];
	  sam = sam + nSa*lM*(lM+1)/2;
	else
	  ding = [ding,sam + [1 : lM*(lM+1)/2]];
      sam = sam + lM*(lM+1)/2;
	end;
    ding  = [ding,sam+1:ll];
    ind(:,i) = ding';
  end;
end;





