function [E,iR1,R2,Z] = e_feat(vec,x,y,g,Syy,nhid,Nn,F)

[ninp,npat,nout] = size(x);
nfeat = size(F,1);
if nargin < 8
  rho = [];
end;

hyper = vec_to_bmksq(vec,ninp,nfeat,nhid,nout,1,1);
M = hyper.M*F;
S = hyper.S;
B = hyper.B;
D = hyper.D;

Sa = hyper.K*hyper.K';
[ev,ew] = eig(Sa);
ind = find(diag(ew) < 1e-6);
for i = 1:length(ind)
  Sa = Sa + (1e-6 - ew(ind(i),ind(i)))*ev(:,ind(i))*ev(:,ind(i))';
end;
iSa = inv(Sa);
iSaM = iSa*M;

Z = tanh(Tx(B,x) + reshape(D*g(:)',nhid,npat,nout));
Z(nhid+1,:,:) = g;

%%%  Zie Appendix A  %%%

R1 = Tx(Z,Z,2,3)/(S^2) + add_reps(iSa,2,nout);
R2 = Tx(Z,y,[2 1],[3 2])/(S^2) + iSa*M;
R3 = Syy/(S^2) + sum(M.*(iSa*M));

iR1 = Tinv(R1);
size(iR1)

detR1 = zeros(nout,1);
for i = 1:nout
  detR1(i) = det(R1(:,:,i));
end;

E = 2*Nn*log(S) + log(det(Sa)) + log(detR1)' + R3 - sum(R2.*Tx(iR1,R2,[2 1],[3 2]));

E = E/2;
iR1 = iR1(:)';
R2 = R2(:)';
Z = Z(:)';













