function hyper = init_gating(ninp,nhid,nout,nprior,nSa,nB,nfeat);

if nargin < 2,
  nhid = 3;
end

if nargin < 3,
  nout = 100;
end

B = 0.01*randn(nhid,ninp,nB);
M = 0.1*randn(nhid+1,nprior);
D = 0.1*randn(nhid,1);
for i = 1:nSa
  dummy = randn(nhid+1,nout);
  K2 = dummy*dummy'/nout;
  K(:,:,i) = 0.1*sqrtm(K2);
end;
S = 1.5;
q = rand(nprior,nfeat);

hyper.B = B;
hyper.M = M;
hyper.D = D;
hyper.K = K;
hyper.S = S;
hyper.q = q;

