function hyper = init_bmksq(ninp,nhid,nout,nprior,nSa,nB);

if nargin < 4
  nprior = 1;
end

if nargin < 5,
  nSa = nprior;
end

if nargin < 6
  nB = 1;
end

B = 0.01*randn(nhid,ninp,nB);
M = 0.1*randn(nhid+1,nprior);
D = 0.1*randn(nhid,1);
for i = 1:nSa
  dummy = randn(nhid+1,nout);
  K2 = dummy*dummy'/nout;
  K(:,:,i) = 2*sqrtm(K2);
end;
S = 1.5;
q = ones(nprior,1)/nprior;

hyper.B = B;
hyper.M = M;
hyper.D = D;
hyper.K = K;
hyper.S = S;
hyper.q = q;

