function gr = grad_emG(vec,ind,x,y,g,F,Syy,nhid,Nn,rho_o);

[nprior,nout] = size(rho_o);
nfeat         = size(F,1);

e_rho = exp(-reshape(vec(end-nprior*nfeat+1:end),nprior,nfeat)*F);
S_rho = ones(nprior,1)*sum(e_rho);
rho   = e_rho./S_rho;

gr = zeros(1,length(vec));

for i = 1:nprior
  GG = grad_bmksq(vec(ind(:,i)),x,y,g,Syy,nhid,Nn,rho_o(i,:));
  gr(ind(:,i)) = gr(ind(:,i)) + GG(1:length(ind(:,i)));
end;

dq = -(rho - rho_o)*F';
gr(end-nprior*nfeat+1:end) = dq(:);
gr = gr';
