function gr = grad_em(vec,ind,x,y,g,Syy,nhid,Nn,rho);

ninp = size(x,1);
[nprior,nout] = size(rho);

e_rho = exp(vec(end-nprior+1:end));
S_rho = repmat(sum(e_rho),nprior,1);
q     = e_rho./S_rho;

gr = zeros(1,length(vec));

for i = 1:nprior
  gr(ind(:,i)) = gr(ind(:,i)) + grad_bmksq(vec(ind(:,i)),x,y,g,Syy,nhid,Nn,rho(i,:));
end;

gr(end-nprior+1:end) = -sum(rho,2) + q*sum(rho(:));
gr = gr';
% gr(end-nprior) = 0;
% gr(nhid*ninp+nprior*nhid+1:nhid*ninp+nprior*nhid+nhid*(nhid+1)/2) = 0;
