function G = grad_bmksq(vec,x,y,g,Syy,nhid,Nn,rho)

[ninp,npat,nout] = size(x);
if nargin < 8
  rho = [];
end;

hyper = vec_to_bmksq(vec,ninp,1,nhid,nout,1,1);
B = hyper.B;
M = hyper.M;
D = hyper.D;
S = hyper.S;
K = hyper.K;
q = hyper.q;

Sa = K*K';
[ev,ew] = eig(Sa);
ind = find(diag(ew) < 1e-6);
for i = 1:length(ind)
  Sa = Sa + (1e-6 - ew(ind(i),ind(i)))*ev(:,ind(i))*ev(:,ind(i))';
end;
iSa = inv(Sa);
iSaM = iSa*M;

z = Tx(B,x) + reshape(D*g(:)',nhid,npat,nout);
Z = tanh(z);
Z(nhid+1,:,:) = g;
ZZ = Tx(Z,Z,2,3);

R1 = ZZ/(S^2) + add_reps(iSa,2,nout);
R2 = Tx(Z,y,[2 1],[3 2])/(S^2) + repmat(iSaM,1,nout);
R3 = Syy/(S^2) + M'*iSaM*sum(rho);

detR1 = zeros(nout,1);
iR1 = Tinv(R1);
IC2 = Tx(1./(cosh(z).^2),g,[],[2 1; 3 2]);
IC2 = [IC2;ones(1,npat,nout)];

for i = 1:nout
  detR1(i) = det(R1(:,:,i));
end;


dZdB = Tx(IC2,x,[],[2 3]');
dR1dB = Tx(Z,dZdB,[2 3],[3 4])/S^2;
dR2dB = Tx(y,dZdB,[1 3],[2 4])/S^2;
iR1R2 = Tx(iR1,R2,[2 1],[3 2]);
qiR1R2 = iR1R2.*repmat(rho,nhid+1,1);

grad.B = squeeze(Tx(rho,Tx(iR1,dR1dB,1,[2 2;3 4]),[2 3]))' - ...
         Tx(dR2dB,qiR1R2,[3 2],1)' + ...
         Tx(iR1R2,Tx(dR1dB,qiR1R2,1,[4 2]),[2 3],1)';
grad.B = grad.B(1:nhid,:);

grad.M = sum(rho)*iSa*M - iSa*(iR1R2*rho');

grad.D = Tx(iR1,Tx(Z,IC2,2,3)/S^2,1,[2 3]')*rho' - ...
          Tx(Tx(IC2,y,[2 1],[3 2])/(S^2),qiR1R2,2,1) + ...
		  Tx(iR1R2,Tx(Tx(Z,IC2,2,3)/S^2,qiR1R2,1,[3 2]),2,1); 
grad.D = grad.D(1:nhid);

gradSa = sum(rho)*iSa - iSa*squeeze(Tx(rho,iR1,[2 3]))*iSa - ....
         iSa*M*M'*iSa*sum(rho) + ...
         iSa*M*(iR1R2*rho')'*iSa + iSa*(iR1R2*rho')*M'*iSa - ...
         iSa*qiR1R2*(iSa*iR1R2)';
          
grad.K = gradSa'*K + gradSa*K;
grad.K = (grad.K + grad.K' - diag(diag(grad.K)))/2;

grad.S = (Nn/S - Syy/S^3)*rho' - rho*Tx(iR1,ZZ,[1 2]',3)/S^3 + ...
    sum(sum(2*Tx(Z,y,[2 1],[3 2]).*qiR1R2 - 2*Tx(iR1R2,ZZ,1,[2 3]).*qiR1R2/2))/S^3;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  ????
grad.q = 0*q;

G = bmksq_to_vec(grad);
