function Z = Tx(A,B,varargin)
[contract,delta,vars] = complete(0,varargin{:});

% function Z = Tx(A,B,contract,delta)
%
% A           : Tensor 1
% B           : Tensor 2
% contract    : N x 2 matrix of the dimensions to be contracted.
% delta       : M x 2 matrix of the dimensions which should be equal
%
% Z           : A x B

nntwarn off

D1 = size(A);
D2 = size(B);

if length(contract)
  c1 = contract(:,1)';
  if size(contract,2) == 1
    c2 = contract(:,1)';
  else
    c2 = contract(:,2)';
  end
else
  c1 = [];
  c2 = [];
end;

if length(delta)
  d1 = delta(:,1)';
  if size(delta,2) == 1
    d2 = delta(:,1)';
  else
    d2 = delta(:,2)';
  end
else
  d1 = [];
  d2 = [];
end;

mem = 101e6;
if length(vars)
  for i = 1:length(vars)
    mem = mem - vars(i).bytes;
  end;
end;
  
if nargin < 3
  if ndims(A) == 2

  % Product of a matrix and a tensor. The second dimension of the matrix 
  % contracts with the first dimension of the tensor.

    n = D2(1);
    m = prod(D2)/n;
    B = reshape(B,n,m);
    Z = reshape(A*B,[D1(1),D2(2:end)]);

  elseif ndims(B) == 2
    
  % Vice versa

    A = permute(A,[2,1,[3:ndims(A)]]);
    n = D1(2);
    m = prod(D1)/n;

    A = reshape(A,n,m)';
    D1(2) = [];
    Z = permute(reshape(A*B,[D1,D2(2)]),[1,length(D1)+1,[2:length(D1)]]);
  else
    
  % Two tensors, contraction of the second dimension of A with the
  % first of B. Fusing of all dimensions after the second.

    n1= D1(2);
    n2= D2(1);
    m = prod(D1)/n1;

    B = add_reps(B,0,D1(1));

    Z = reshape(sum(A.*B,2),D1([1,3:end]));
  end
elseif nargin < 4

% Two tensors, no fusion

  l2 = length(c1);
  l1 = ndims(A) - l2;
  shuffle1 = [1:ndims(A)];
  shuffle1(c1) = [];
  shuffle1 = [shuffle1,c1];
  A = permute(A,shuffle1); 
  D1 = D1(shuffle1);
  if l1
    A = reshape(A,prod(D1(1:l1)),prod(D1(l1+1:end))); 
  else
    A = A(:)'; 
  end;

  shuffle2 = [1:ndims(B)];
  shuffle2(c2) = [];
  shuffle2 = [c2,shuffle2];
  B = permute(B,shuffle2);  
  D2 = D2(shuffle2);
  if length(D2) > l2
    B = reshape(B,prod(D2(1:l2)),prod(D2(l2+1:end))); 
  else
    B = B(:);
  end;
  if l1
    flip = D1(1:l1);
  else 
    flip = 1;
  end;
  if l2 < length(D2)
    flap = D2(l2+1:end);
  else 
    flap = 1;
  end;
  Z = reshape(A*B,[flip,flap]);
else
  shuffle1 = [1:ndims(A)];
  shuffle1([c1,d1]) = [];
  A = permute(A,[c1 d1 shuffle1]);

  shuffle2 = [1:ndims(B)];
  shuffle2([c2,d2]) = [];
  B = permute(B,[c2 d2 shuffle2]);

  cdims1 = prod(D1(c1));
  cdims2 = prod(D2(c2));
  ddims1 = prod(D1(d1));
  ddims2 = prod(D2(d2));
  sdims1 = prod(D1)/cdims1/ddims1;
  sdims2 = prod(D2)/cdims2/ddims2;

  A = reshape(A,[cdims1,ddims1,sdims1]);
  B = reshape(B,[cdims2,ddims2,sdims2]);
  Z = zeros([prod(D1(shuffle1)),prod(D2(shuffle2)),prod(D1(d1))]);
  if (size(A,2) < prod(D1(shuffle1))*prod(D2(shuffle2)))
    for i = 1:size(A,2)
      Z(:,:,i)=reshape(A(:,i,:),cdims1,sdims1)'*reshape(B(:,i,:),cdims2,sdims2);
    end
  else
    for i = 1:prod(D1(shuffle1))
      for j = 1:prod(D2(shuffle2))
        Z(i,j,:) = sum(A(:,:,i).*B(:,:,j),1);
      end;
    end;      
  end;
  if length([D1(shuffle1),D2(shuffle2),D1(d1)]) > 1
    Z = reshape(Z,[D1(shuffle1),D2(shuffle2),D1(d1)]);
  else
    if length([D1(shuffle1),D2(shuffle2),D1(d1)]) 
      Z = Z(:);
    else
      Z = squeeze(Z);
    end;
  end;
end


% Z = squeeze(Z);
% if ~isequal(bZ,Z)
%   fprintf(1,'size bZ: %s \n',num2str(size(bZ))); 
%   fprintf(1,'size Z: %s \n',num2str(size(Z))); 
%   fprintf(1,'input A: %s \n',num2str(D1)); 
%   fprintf(1,'input B: %s \n',num2str(D2)); 
%   fprintf(1,'input Ana: %s \n',num2str(size(A))); 
%   fprintf(1,'input Bna: %s \n',num2str(size(B))); 
%   fprintf(1,'contract 1: %s \n',num2str(c1)); 
%   fprintf(1,'contract 2: %s \n',num2str(c2)); 
%   fprintf(1,'delta 1: %s \n',num2str(d1)); 
%   fprintf(1,'delta 2: %s \n',num2str(d2)); 
%   fprintf(1,'-------------------------------------------------------------\n'); 
%   save /tmp/huppel
%   fprintf(1,'klaar\n');
%   pause
% end;
% sZ = size(Z);
% sZo = size(squeeze(Z));
% if (sum(sZ(1:length(sZo)) == sZo) & length(sZ) ~= length(sZo))
% fprintf(1,'Warning: size = %s\n',num2str(sZo));
% end;








