% To get: x y g F (features nf x ntask)

ntask   = 343;
nrun    = 10;
priors  = 2;
nhid    = 2;
itmax   = 1000;
trainnr = 100;
tijd    = zeros(nrun);

for iter=1:nrun,
  [ninp,npat,nout] = size(x);
  fprintf('Now starting run %d.\n\n',iter);

  ii{iter} = randperm(npat);
  trainpat = ii{iter}(1:trainnr);
  task = randperm(nout);
  it{iter} = task(1:ntask);

  xt = x(:,trainpat,it{iter});
  yt = y(trainpat,it{iter});
  Ft = F(:,it{iter});
  gt = g(trainpat,it{iter});

  for nprior = 2:priors
    [hyper{iter}, tt(iter,:)] = TG4L2L(xt,yt,gt,Ft,nhid,nprior);
  end

  save TG0409 
end;








