% Hierarchical cluster algorithm
% input: distance matrix, clustering optie, absolute or relative scale,
%        number of required clusters
% output: weights of cluster, ordening of dendogram
% three options: single-link, complete-link, and ward's algorithm
% produces dendogram

function [grootte,ordening] = cluster(realdist,optie,absoluut,aantal);

if nargin < 2,
  optie = 'ward';
end
if nargin < 3,
  absoluut = 1;
end
if nargin < 4,
  aantal = 2;
end

N = length(realdist);

if (optie(1:4) == 'sing'),
   a1 = 0.5*ones(N,1);
   a2 = 0.5*ones(N,1);
   a3 = zeros(N,1);
   a4 = -0.5*ones(N,1);
   ward = 0;
elseif (optie(1:4) == 'comp'),
   a1 = 0.5*ones(N,1);
   a2 = 0.5*ones(N,1);
   a3 = zeros(N,1);
   a4 = 0.5*ones(N,1);
   ward = 0;
elseif (optie(1:4) == 'ward'),
   ward = 1;
   a4 = zeros(N,1);
end

maxie = max(realdist(:))*1000;
realdist = triu(realdist) + maxie*tril(ones(size(realdist)));
     % alles onder de diagonaal wordt op voldoende groot gezet:
     % alleen boven de diagonaal telt

gew = ones(N,N);
             % gew(i,j) is het "gewicht" dat aan cluster i wordt
             % toegekend na j samenvoegingen


level = zeros(N,1);
samen = zeros(N,2);
for i=1:N,
    if (i>1),
       gew(:,i) = gew(:,i-1);
    end
    over = find(gew(:,i));
    M = length(over);    % = N-i+1

    overdist = realdist(over,over);
    [dummy,flap] = min(overdist);
    [level(i),d2] = min(dummy);
    d1 = flap(d2);
    c1 = over(d1);
    c2 = over(d2);

    samen(i,:) = [c1,c2];         % c1 en c2 worden samengevoegd
                                  % c2 verdwijnt; c1 blijft bestaan
    if (ward),
       n3 = gew(:,i);
       n1 = gew(c1,i)*ones(size(n3));
       n2 = gew(c2,i)*ones(size(n3));
       noemer = n1+n2+n3;
       a1 = (n1+n3)./noemer;
       a2 = (n2+n3)./noemer;
       a3 = -n3./noemer;
    end

           % de afstanden worden geupdate; eigenlijk 3 keer hetzelfde
           % herhaald omdat alleen de afstanden boven de diagonaal
           % betekenis hebben (zou slimmer kunnen...)
           % verschillende algoritmes komen in feite neer op verschillende
           % definities voor de afstand tussen clusters; "ward" is een
           % soort gewogen gemiddelde; "complete link" en "single link"
           % zijn worst case (nieuwe afstand is de verste van de twee)
           % en best case (nieuwe afstand is de dichtstbijzijnde);
           % codering lijkt wat vreemd maar maakt het mogelijk de 3
           % algoritmes in 1 keer op te schrijven.

    kk = 1:d1-1;             % alles onder c1
    if length(kk),
       jj = over(kk);
       realdist(jj,c1) = a1(jj).*realdist(jj,c1)+a2(jj).*realdist(jj,c2)+...
       a3(jj)*realdist(c1,c2)+a4(jj).*abs(realdist(jj,c1)-realdist(jj,c2));
       realdist(jj,c2) = maxie;
    end

    kk = d1+1:d2-1;          % alles tussen c1 en c2
    if length(kk),
       jj = over(kk);
       realdist(c1,jj) = a1(jj)'.*realdist(c1,jj)+a2(jj)'.*realdist(jj,c2)'+...
       a3(jj)'*realdist(c1,c2)+a4(jj)'.*abs(realdist(c1,jj)-realdist(jj,c2)');
       realdist(jj,c2) = maxie;
    end

    kk = d2+1:M;             % alles boven c2
    if length(kk),
       jj = over(kk);
       realdist(c1,jj) = a1(jj)'.*realdist(c1,jj)+a2(jj)'.*realdist(c2,jj)+...
       a3(jj)'.*realdist(c1,c2)+a4(jj)'.*abs(realdist(c1,jj)-realdist(c2,jj));
       realdist(c2,jj) = maxie;
    end

            % c2 wordt verwijderd; gewicht van c2 gaat naar c1
    realdist(c1,c2) = maxie;
    gew(c1,i) = gew(c1,i)+gew(c2,i);
    gew(c2,i) = 0;
end

% KLAAR! de clustering is gevonden; de rest is lijntjes plotten
% dit gebeurt van achter naar voren

if (absoluut==0) level = 1:N; end

dummy = N:-1:1;
samen = samen(dummy,:);
level = level(dummy);
gew = [gew(:,dummy),ones(N,1)];
from = samen(:,1);
off = samen(:,2);

lijn = zeros(1,N);
laatst = zeros(1,N);
lijn(1) = N/2;
laatst(1) = 1.02*level(2);

groepnaam = 1:N;
grootte = zeros(size(groepnaam));
for i=2:N,
    oldy = lijn(from(i));
    oldx = laatst(from(i));
    newx = level(i);
    if (i-1 == aantal),
       groepnaam = find(lijn > 0);
       grootte = gew(groepnaam,i);
    end
    gew1 = gew(from(i),i+1);
    gew2 = gew(off(i),i+1);
    [d1,d2] = max([gew1,gew2]);
    teken = 3-2*d2;
    newy1 = oldy-teken*gew2/2;
    newy2 = oldy+teken*gew1/2;

    laatst(from(i)) = newx;
    laatst(off(i)) = newx;
    lijn(from(i)) = newy1;
    lijn(off(i)) = newy2;

end

[dummy,ordening] = sort(lijn);
for i=1:length(groepnaam),
    qqq(i) = find(ordening == groepnaam(i));
end
[dummy,ind] = sort(qqq);
grootte = grootte(ind)';


